# Cactus Ports Collection

[**Compatibility Key**](#compatibility-key) | [**Available Ports**](#available-ports) | [**Removed Ports**](REMOVED-PORTS.md)

This page contains a list of mods that have been ported to Cactus, and their
corresponding compatibility level. This is my ***personal and curated collection***
of mods, which means that I have configured them to work with Cactus,
verified their compatibility with Cactus, and have done some basic virus
scans on them, or a combination of the above. All the platforms in my tree are
signed by me using my PGP key which can be found at the [Cactus](../README.md)
home page. The goal of this collection is not to have the latest version of
every mod, or to have every mod available, but rather to have at least one
working version of some mods on Cactus. All mods ported to Cactus are
tailored for ***Offline Single Player*** and contribute something unique to
the ecosystem. Mods that are just simple repackagings of other mods, or tools,
will not be ported. Multiplayer-only mods will not be ported to Cactus. I'll
periodically prune and drop mods from my tree as needed.

Please read the **Compatibility Key** below, and the **Known Issues** section
for any mod you wish to play. Before playing any mod, make sure you use the
**Backup** feature within Cactus, and if in doubt, you can backup your entire
**Diablo II Root Directory**. The lists are displayed in alphabetical order.

## Backup Mirror

If you have any issues downloading a mod, try downloading them from the
[***Backup Mirror***](https://xyinn.org/diablo/platforms/) instead.

## Disclaimer

For every mod I port and host, I will provide the original source files
(defined as the publicly distributed files by the original author) I used
to create the bundle (if available). These sources can be used to audit
the files I'm distributing.

If you are the creator of a mod that was ported and listed here, but you either:

- Don't want it to be hosted by me
- Want to maintain the platform yourself
- Or any other reason

Please send me an email at **`cactus@xyinn.org`**, and I'll remove it. For the
sake of transparency, any removal requests, and their reasoning will be
documented.

If you are interested in porting a mod over to Cactus, please follow the advice
documented in the [***Cactus Porting Advice***](PORTING-ADVICE.md) page. Feel
free to email me if you have any porting questions, and I'll try my best to
assist with general, high level advice.

Please be aware that this is a time consuming process for myself so in
order for this not to become a burden on me, I will only port a select
and curated list of mods at my discretion. This means I also won't be
accepting mod updates from developers. On my own time, I may provide
updated ports for certain mods.

Lastly, I do prefer to have a decentralized community where different people can
maintain their own Cactus Ports Collection trees independently. This allows for
differences of opinion, and allows some sort of redundancy of the Cactus platform
files. We are not necessarily in competition with each other (well.. we are in a
friendly way, haha), so we can ultimately, together, raise the standard of the
Diablo II (Original) modding scene, in an independent and distributed fashion.
Because of this, it is the responsability of the maintainer of each Cactus Ports
Collection tree to keep up with upstream updates, and maintain compatibility
with Cactus. Cactus is a mature platform with over **10** years of development
(including Cactus' pre-cursor, **Bliss Version Switcher**). I don't expect any
major or breaking changes to the way Cactus works, but I'm not guaranteeing
to keep compatibility with any external trees, and will make breaking changes
if necessary. In reality, you should be fine.

## Compatibility Key

- **Platinum**
	- Works perfectly out of the box with:
		- **Cactus**
		- **cnc-ddraw** (DirectDraw)
		- **DSOAL w/ OpenAL Soft** (3D Sound, EAX)
- **Gold**
	- Works well, can be launched through Cactus, and Saves are ***protected***,
	  but there are some issues which may require user intervention.

Inspired by [Wine](https://www.winehq.org/)'s [Rating System](https://wiki.winehq.org/AppDB_Rating_Definitions)

## Available Ports

There are currently **50** mods available in the ***Cactus Ports Collection***.

### Platinum (44)

- [***1.07.41***](<./1. Platinum/1.07.41.md>)
- [***1.09b Final Edition***](<./1. Platinum/1.09b Final Edition.md>)
- [***Ancestral Recall (1.10)***](<./1. Platinum/Ancestral Recall (1.10).md>)
- [***Back to Hellfire (1.02)***](<./1. Platinum/Back to Hellfire (1.02).md>)
- [***Baldur's Gate (1.06 Beta)***](<./1. Platinum/Baldur's Gate (1.06 Beta).md>)
- [***Blackened (3.5 Beta)***](<./1. Platinum/Blackened (3.5 Beta).md>)
- [***Blazing Fire (4.1F)***](<./1. Platinum/Blazing Fire (4.1F).md>)
- [***Cryptforge (3a)***](<./1. Platinum/Cryptforge (3a).md>)
- [***D2: Ironman (6.04 Beta)***](<./1. Platinum/D2 - Ironman (6.04 Beta).md>)
- [***D2FC (Season 4)***](<./1. Platinum/D2FC (Season 4).md>)
- [***D2Scrabble (7a)***](<./1. Platinum/D2Scrabble (7a).md>)
- [***Dark Alliance (0.05.07.01)***](<./1. Platinum/Dark Alliance (0.05.07.01).md>)
- [***Darkness Weaves (2.0)***](<./1. Platinum/Darkness Weaves (2.0).md>)
- [***Duel Mod (1.0.0)***](<./1. Platinum/Duel Mod (1.0.0).md>)
- [***Eastern Sun (3.00)***](<./1. Platinum/Eastern Sun (3.00).md>)
- [***Eastern Sun Rises (5.2D)***](<./1. Platinum/Eastern Sun Rises (5.2D).md>)
- [***Genesis (2.0+)***](<./1. Platinum/Genesis (2.0+).md>)
- [***Hell on Earth (2.9 Beta)***](<./1. Platinum/Hell on Earth (2.9 Beta).md>)
- [***Hell Unleashed (1.21z - Solo Edition)***](<./1. Platinum/Hell Unleashed (1.21z - Solo Edition).md>)
- [***Hellfire II: Lazarus (7 Winter MMO Edition)***](<./1. Platinum/Hellfire II - Lazarus (7 Winter).md>)
- [***Immersion (1.05 b104)***](<./1. Platinum/Immersion (1.05 b104).md>)
- [***Is Alive (27.9.2015)***](<./1. Platinum/Is Alive (27.9.2015).md>)
- [***Lament of Innocence (1.06a)***](<./1. Platinum/Lament of Innocence (1.06a).md>)
- ***Le Royaume des Ombres***
	- [***Le Royaume des Ombres (5.03)***](<./1. Platinum/Le Royaume des Ombres (5.03).md>)
	- [***Le Royaume des Ombres (6.00 Beta)***](<./1. Platinum/Le Royaume des Ombres (6.00 Beta).md>)
- ***Median / Median XL (Brother Laz Era)***	
	- ***Median***
		- [***Median (2006 v1.12)***](<./1. Platinum/Median (2006 v1.12).md>)
		- [***Median (2007 v1.31)***](<./1. Platinum/Median (2007 v1.31).md>)
		- [***Median (2008 v1.57b)***](<./1. Platinum/Median (2008 v1.57b).md>)
	- ***Median XL***
		- [***Median XL (1.70) (Initial Release)***](<./1. Platinum/Median XL (1.70).md>)
		- [***Median XL (1.80) (First Stable Version Of The Initial Release)***](<./1. Platinum/Median XL (1.80).md>)
		- [***Median XL (1.99d)***](<./1. Platinum/Median XL (1.99d).md>)
		- [***Median XL (1.Z9)***](<./1. Platinum/Median XL (1.Z9).md>)
		- [***Median XL (Omega v003)***](<./1. Platinum/Median XL (Omega v003).md>)
		- [***Median XL (2012 v005) (Brother Laz's Final Release)***](<./1. Platinum/Median XL (2012 v005).md>)
- ***Middle Earth***
	- [***Middle Earth (1.8) (1.09b)***](<./1. Platinum/Middle Earth (1.8).md>)
	- [***Middle Earth (1.92) (1.10)***](<./1. Platinum/Middle Earth (1.92).md>)
- [***Nezeramontias (1.09)***](<./1. Platinum/Nezeramontias (1.09).md>)
- [***OBLIVION AfTerStoRy (3.0)***](<./1. Platinum/OBLIVION AfTerStoRy (3.0).md>)
- [***Pagan Heart (0.995b)***](<./1. Platinum/Pagan Heart (0.995b).md>)
- [***Pandora's Trials (1.1)***](<./1. Platinum/Pandora's Trials (1.1).md>)
- [***Paradox (0.2.7 Alpha)***](<./1. Platinum/Paradox (0.2.7 Alpha).md>)
- [***Perfect Drop Mod (1.07b)***](<./1. Platinum/Perfect Drop Mod (1.07b).md>)
- [***Reign of Shadow (0.92)***](<./1. Platinum/Reign of Shadow (0.92).md>)
- [***Requiem of Sorrow (6.08)***](<./1. Platinum/Requiem of Sorrow (6.08).md>)
- [***Seven Lances (1.30 Beta 2)***](<./1. Platinum/Seven Lances (1.30 Beta 2).md>)
- [***Succulent (2024-12-05-0000)***](<./1. Platinum/Succulent (2024-12-05-0000).md>)
- [***The Fury Within - Awakening (Alpha 2)***](<./1. Platinum/The Fury Within - Awakening (Alpha 2).md>)
- [***The Hordes of Chaos (8.1 Beta)***](<./1. Platinum/The Hordes of Chaos (8.1 Beta).md>)
- [***The Midlands (0.22c)***](<./1. Platinum/The Midlands (0.22c).md>)
- [***Trance (2015-12-26)***](<./1. Platinum/Trance (2015-12-26).md>)
- [***Underworld (2.9)***](<./1. Platinum/Underworld (2.9).md>)
- [***Valhalla (5.03)***](<./1. Platinum/Valhalla (5.03).md>)
- [***World of Chaos (0.4 Beta)***](<./1. Platinum/World of Chaos (0.4 Beta).md>)
- [***You Gotta Be Kidding Me (1.11b)***](<./1. Platinum/You Gotta Be Kidding Me (1.11b).md>)

### Gold (6)

- [***Disotheb (Patch 1)***](<./2. Gold/Disotheb (Patch 1).md>)
- [***Escape from the Afterlife (1.56 - Hotfix 2)***](<./2. Gold/Escape from the Afterlife (1.56 - Hotfix 2).md>)
- [***Resurgence (R1.10.L.9)***](<./2. Gold/Resurgence (R1.10.L.9).md>)
- [***The Sin War (3.50)***](<./2. Gold/The Sin War (3.50).md>)
- [***World Youth En (3.0 Remastered)***](<./2. Gold/World Youth En (3.0 Remastered).md>)
- [***Zy-El (4.4c)***](<./2. Gold/Zy-El (4.4c).md>)
